/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_bal_Latn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabi";
        final String metaValue_ru = "Rusi";
        final String metaValue_he = "Ebr\u00e1ni";
        final String metaValue_ja = "J\u00e1p\u00e1ni";
        final String metaValue_km = "Khm\u00e9r";
        final String metaValue_kn = "Kannad\u00e1";
        final String metaValue_ml = "Maly\u00e1lam";
        final String metaValue_su = "Sud\u00e1ni";
        final String metaValue_syr = "Siriek";
        final String metaValue_ta = "T\u00e1mel";
        final String metaValue_th = "T\u00e1i";
        final String metaValue_vai = "W\u00e1i";
        final String metaValue_ssy = "Sah\u00f3";
        final Object[][] data = new Object[][] {
            { "001", "Dony\u00e1" },
            { "002", "Afrik\u00e1" },
            { "003", "Shem\u00e1li Amrik\u00e1" },
            { "005", "Zerb\u00e1ri Amrik\u00e1" },
            { "009", "Ushi\u00e1n\u00e1" },
            { "011", "R\u00f3nendi Aprik\u00e1" },
            { "013", "My\u00e1ni Amrik\u00e1" },
            { "014", "R\u00f3dar\u00e1tki Aprik\u00e1" },
            { "015", "Shem\u00e1li Aprik\u00e1" },
            { "017", "My\u00e1ni Aprik\u00e1" },
            { "018", "Jonubi Aprik\u00e1" },
            { "019", "Amrik\u00e1" },
            { "021", "Shem\u00e1li Amrika" },
            { "029", "Ker\u00e9bian" },
            { "030", "R\u00f3dar\u00e1tki \u00c1si\u00e1" },
            { "034", "Zerb\u00e1ri \u00c1si\u00e1" },
            { "035", "Zerb\u00e1rr\u00f3dar\u00e1tki \u00c1si\u00e1" },
            { "039", "Zerb\u00e1ri Yurop" },
            { "053", "\u00c1str\u00e1l\u00e1si\u00e1" },
            { "054", "Melan\u00e9si\u00e1" },
            { "057", "M\u00e1ekr\u00f3n\u00e9si Damag" },
            { "061", "P\u00f3linisi\u00e1" },
            { "142", "\u00c1si\u00e1" },
            { "143", "My\u00e1ni \u00c1si\u00e1" },
            { "145", "R\u00f3nendi \u00c1si\u00e1" },
            { "150", "Yurop" },
            { "151", "R\u00f3dar\u00e1tki Yurop" },
            { "154", "Shem\u00e1li Yurop" },
            { "155", "R\u00f3nendi Yurop" },
            { "202", "Sab-Sah\u00e1ri Aprik\u00e1" },
            { "419", "L\u00e1tini Amrik\u00e1" },
            { "AC", "Asenshan Isl\u00e1nd" },
            { "AD", "Andorr\u00e1" },
            { "AE", "Em\u00e1r\u00e1t" },
            { "AF", "Awgh\u00e1nest\u00e1n" },
            { "AG", "Antiga o Barbuda" },
            { "AI", "Angwila" },
            { "AL", "Alb\u00e1ni\u00e1" },
            { "AM", "\u00c1rmini\u00e1" },
            { "AO", "Ang\u00f3l\u00e1" },
            { "AQ", "Ant\u00e1rktik\u00e1" },
            { "AR", "Arjentin\u00e1" },
            { "AS", "Amriki Sam\u00f3\u00e1" },
            { "AT", "\u00c1stri\u00e1" },
            { "AU", "\u00c1sthr\u00e9li\u00e1" },
            { "AW", "Aruba" },
            { "AX", "\u00c1wl\u00e1nd Isl\u00e1nd" },
            { "AZ", "\u00c1zerb\u00e1ij\u00e1n" },
            { "BA", "B\u00f3sni\u00e1" },
            { "BB", "Barbad\u00f3s" },
            { "BD", "Bangalad\u00e9sh" },
            { "BE", "B\u00e9ljiam" },
            { "BF", "Burkin\u00e1 P\u00e1s\u00f3" },
            { "BG", "Balg\u00e1ri\u00e1" },
            { "BH", "Bahren" },
            { "BI", "Borondi" },
            { "BJ", "Benin" },
            { "BL", "St. Bart\u00e9l\u00e9mi" },
            { "BM", "Barmud\u00e1" },
            { "BN", "Brun\u00e1i" },
            { "BO", "Boliwi\u00e1" },
            { "BQ", "Ker\u00e9bi Nedarl\u00e1nd" },
            { "BR", "Br\u00e1zil" },
            { "BS", "Bahamas" },
            { "BT", "Buth\u00e1n" },
            { "BV", "B\u00f3wet Isl\u00e1nd" },
            { "BW", "Bostw\u00e1n\u00e1" },
            { "BY", "B\u00e9l\u00e1rus" },
            { "BZ", "Belize" },
            { "CA", "Kaynadh\u00e1" },
            { "CC", "Kukus Isl\u00e1nd (Kileng)" },
            { "CD", "K\u00e1ng\u00f3-Kensh\u00e1s\u00e1" },
            { "CF", "My\u00e1ni Apriki Esht\u00e1n" },
            { "CG", "K\u00e1ng\u00f3-Br\u00e1z\u00e1wille" },
            { "CH", "Swizarl\u00e1nd" },
            { "CI", "K\u00f3t\u00e9 di\u00e1w\u00f3ri" },
            { "CK", "Kuk Isl\u00e1nd" },
            { "CL", "Chilay" },
            { "CM", "Kaymrun" },
            { "CN", "Chin" },
            { "CO", "K\u00f3lambi\u00e1" },
            { "CP", "Klipperton Isl\u00e1nd" },
            { "CQ", "S\u00e1rk" },
            { "CR", "K\u00f3st\u00e1 Rik\u00e1" },
            { "CU", "Kyub\u00e1" },
            { "CV", "Kap Ward\u00e9" },
            { "CW", "Chur\u00e1ch\u00e1\u00f3" },
            { "CX", "Kresmes Isl\u00e1nd" },
            { "CY", "S\u00e1ipras" },
            { "CZ", "Ch\u00e9chi\u00e1" },
            { "DE", "Jarmani" },
            { "DG", "Di\u00e9g\u00f3 G\u00e1rshi\u00e1" },
            { "DJ", "Djebuti" },
            { "DK", "Denm\u00e1rk" },
            { "DM", "Duminik\u00e1" },
            { "DO", "Duminiki Est\u00e1n" },
            { "DZ", "Aljiri\u00e1" },
            { "EA", "Si\u00f3t\u00f3 o Melil\u00e1" },
            { "EC", "Ekw\u00e1d\u00f3r" },
            { "EE", "Est\u00f3ni\u00e1" },
            { "EG", "Mesr" },
            { "EH", "R\u00f3barkati Sah\u00e1r\u00e1" },
            { "ER", "Eritiri\u00e1" },
            { "ES", "Espin" },
            { "ET", "Etupi\u00e1" },
            { "EU", "Yuropi Yunian" },
            { "EZ", "Yurop-damag" },
            { "FI", "Fenl\u00e1nd" },
            { "FJ", "Fiji" },
            { "FK", "P\u00e1kl\u00e1nd Isl\u00e1nd" },
            { "FM", "Mikr\u00f3n\u00e9shi\u00e1" },
            { "FO", "Far\u00f3\u00e9 Isl\u00e1nd" },
            { "FR", "Par\u00e1ns" },
            { "GA", "Gabon" },
            { "GB", "Bart\u00e1ni\u00e1" },
            { "GD", "Geren\u00e1" },
            { "GE", "J\u00e1rji\u00e1" },
            { "GF", "Pr\u00e1nsi Gwi\u00e1n\u00e1" },
            { "GG", "Gwernsay" },
            { "GH", "G\u00e1n\u00e1" },
            { "GI", "Gibr\u00e1ltar" },
            { "GL", "Grinl\u00e1nd" },
            { "GM", "Gambi\u00e1" },
            { "GN", "Gini\u00e1" },
            { "GP", "Gw\u00e1del\u00f3p" },
            { "GQ", "Ekw\u00e1turi Gini\u00e1" },
            { "GR", "Yun\u00e1n" },
            { "GS", "Zerb\u00e1ri J\u00e1rji\u00e1" },
            { "GT", "Gw\u00e1t\u00e9m\u00e1l\u00e1" },
            { "GU", "Gu\u00e1m" },
            { "GW", "Gini\u00e1-Biss\u00e1u" },
            { "GY", "Goy\u00e1n\u00e1" },
            { "HK", "H\u00e1ng K\u00e1ng o SAR Chin" },
            { "HM", "Hard o Mekd\u00f3nald Isl\u00e1nd" },
            { "HN", "Honduras" },
            { "HR", "Kr\u00f3shi\u00e1" },
            { "HT", "Hayti" },
            { "HU", "Hangari" },
            { "IC", "Kanaray Isl\u00e1nd" },
            { "ID", "Endhon\u00e9shi\u00e1" },
            { "IE", "\u00c1erl\u00e1nd" },
            { "IL", "Esr\u00e1il" },
            { "IM", "\u00c1isale Mardom" },
            { "IN", "Hendost\u00e1n" },
            { "IO", "Bart\u00e1ni Hendi Zerdamag" },
            { "IQ", "Er\u00e1k" },
            { "IR", "\u00c9r\u00e1n" },
            { "IS", "\u00c1esl\u00e1nd" },
            { "IT", "It\u00e1li\u00e1" },
            { "JE", "Jers\u00e9" },
            { "JM", "Jam\u00e1ek\u00e1" },
            { "JO", "Ordon" },
            { "JP", "J\u00e1p\u00e1n" },
            { "KE", "Kini\u00e1" },
            { "KG", "Karghazest\u00e1n" },
            { "KH", "Kamb\u00f3dhi\u00e1" },
            { "KI", "Kirib\u00e1ti" },
            { "KM", "Kom\u00f3r\u00f3s" },
            { "KN", "St. Kitts o Newis" },
            { "KP", "Sham\u00e1li K\u00f3ri\u00e1" },
            { "KR", "Zerb\u00e1ri K\u00f3ri\u00e1" },
            { "KW", "Kwayt" },
            { "KY", "Kaymi Isl\u00e1nd" },
            { "KZ", "K\u00e1zakhest\u00e1n" },
            { "LA", "L\u00e1us" },
            { "LB", "Lebn\u00e1n" },
            { "LC", "St. Lusi\u00e1" },
            { "LI", "Lichtenst\u00e9n" },
            { "LK", "Sari Lank\u00e1" },
            { "LR", "L\u00e1ib\u00e9ri\u00e1" },
            { "LS", "Les\u00f3t\u00f3" },
            { "LT", "Litu\u00e1ni\u00e1" },
            { "LU", "Loksemb\u00f3rg" },
            { "LV", "Latwi\u00e1" },
            { "LY", "Liby\u00e1" },
            { "MA", "Mor\u00f3k\u00f3" },
            { "MC", "Mon\u00e1k\u00f3" },
            { "MD", "Moldow\u00e1" },
            { "ME", "Montenegr\u00f3" },
            { "MF", "St. M\u00e1rtin" },
            { "MG", "Madag\u00e1skar" },
            { "MH", "Marshall Isl\u00e1nd" },
            { "MK", "Shem\u00e1li Makduni\u00e1" },
            { "ML", "M\u00e1li" },
            { "MM", "Myanm\u00e1r (Barm\u00e1)" },
            { "MN", "Mang\u00f3li\u00e1" },
            { "MO", "Maka\u00f3 SAR Chin" },
            { "MP", "Shem\u00e1li M\u00e1ri\u00e1n\u00e1 Isl\u00e1nd" },
            { "MQ", "M\u00e1rtinik" },
            { "MR", "Murit\u00e1ni\u00e1" },
            { "MS", "Montserrat" },
            { "MT", "M\u00e1lt\u00e1" },
            { "MU", "Murishias" },
            { "MV", "M\u00e1ldip" },
            { "MW", "Mal\u00e1wi" },
            { "MX", "Meksik\u00f3" },
            { "MY", "Mal\u00e9shi\u00e1" },
            { "MZ", "M\u00f3zambik" },
            { "NA", "Namibi\u00e1" },
            { "NC", "Niu K\u00e1led\u00f3ni\u00e1" },
            { "NE", "N\u00e1iger" },
            { "NF", "N\u00f3rfolk Isl\u00e1nd" },
            { "NG", "N\u00e1ij\u00e9ri\u00e1" },
            { "NI", "Nek\u00e1r\u00e1g\u00f3\u00e1" },
            { "NL", "Nedarl\u00e1nd" },
            { "NO", "N\u00e1rway" },
            { "NP", "N\u00e9p\u00e1l" },
            { "NR", "N\u00e1uru" },
            { "NU", "Niu\u00e9" },
            { "NZ", "Nyu Zil\u00e1nd" },
            { "OM", "Om\u00e1n" },
            { "PA", "P\u00e1n\u00e1m\u00e1" },
            { "PE", "P\u00e9ru" },
            { "PF", "Par\u00e1nsi Pulinishi\u00e1" },
            { "PG", "P\u00e1pu\u00e1 Niu Gini\u00e1" },
            { "PH", "Pelpin" },
            { "PK", "P\u00e1kest\u00e1n" },
            { "PL", "P\u00f3l\u00e1nd" },
            { "PM", "St. P\u00e9ri o Mikw\u00e9lin" },
            { "PN", "Pitkar\u00e9n Isl\u00e1nd" },
            { "PR", "Piur\u00f3 Rik\u00f3" },
            { "PS", "Palastinay Damag" },
            { "PT", "Portog\u00e1l" },
            { "PW", "Pal\u00e1u" },
            { "PY", "Par\u00e1g\u00f3ay" },
            { "QA", "Gatar" },
            { "QO", "T\u00e1l\u00e1n\u00e9n Zerbahrag" },
            { "RE", "R\u00e9yunian" },
            { "RO", "Rum\u00e1ni\u00e1" },
            { "RS", "Sarbi\u00e1" },
            { "RU", "Rus" },
            { "RW", "Rw\u00e1ndh\u00e1" },
            { "SA", "Saudi Arab" },
            { "SB", "Solom\u00e1n Isl\u00e1nd" },
            { "SC", "S\u00e9cheles" },
            { "SD", "Sud\u00e1n" },
            { "SE", "Swidhan" },
            { "SG", "Seng\u00e1pur" },
            { "SH", "St. Hel\u00e9n\u00e1" },
            { "SI", "Slowini\u00e1" },
            { "SJ", "Swalbard o Jan May\u00e9n" },
            { "SK", "Slow\u00e1ki\u00e1" },
            { "SL", "Sierr\u00e1 Le\u00f3ne" },
            { "SM", "San Mari\u00e1n\u00f3" },
            { "SN", "Senig\u00e1l" },
            { "SO", "S\u00f3m\u00e1li\u00e1" },
            { "SR", "Surinaym" },
            { "SS", "Zerb\u00e1ri Sud\u00e1n" },
            { "ST", "S\u00e1\u00f3 T\u00f3me o Prensip" },
            { "SV", "El Salwad\u00f3r" },
            { "SX", "Sint M\u00e1rten" },
            { "SY", "Suri\u00e1" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan d\u00e1 Chonh\u00e1" },
            { "TC", "Tork o K\u00e1ik\u00f3i Isl\u00e1nd" },
            { "TD", "Ch\u00e1d" },
            { "TF", "Pr\u00e1nsi Zerb\u00e1ri Damag" },
            { "TG", "T\u00f3g\u00f3" },
            { "TH", "T\u00e1il\u00e1nd" },
            { "TJ", "T\u00e1jekest\u00e1n" },
            { "TK", "Tok\u00e9l\u00e1u" },
            { "TL", "T\u00e9mur-Leste" },
            { "TM", "Torkmenest\u00e1n" },
            { "TN", "Tunishi\u00e1" },
            { "TO", "Tong\u00e1" },
            { "TR", "Turkiye" },
            { "TT", "Trinidad o Tob\u00e1g\u00f3" },
            { "TV", "Tuwalu" },
            { "TW", "T\u00e1iw\u00e1n" },
            { "TZ", "Tanz\u00e1ni\u00e1" },
            { "UA", "Yukr\u00e9n" },
            { "UG", "Yugandh\u00e1" },
            { "UM", "U.S. Dar\u00e1\u00e9n Isl\u00e1nd" },
            { "UN", "My\u00e1nostom\u00e1ni Gal" },
            { "US", "Amrik\u00e1ay Tep\u00e1k\u00e9n Est\u00e1n" },
            { "UY", "Yur\u00f3g\u00f3ay" },
            { "UZ", "Ozbekest\u00e1n" },
            { "VA", "W\u00e1tik\u00e1n Sethi" },
            { "VC", "St. Wensent o Gren\u00e1din" },
            { "VE", "Wenezw\u00e9l\u00e1" },
            { "VG", "Bret\u00e1ni Ajg\u00e9n Isl\u00e1nd" },
            { "VI", "Amriki Ajg\u00e9n Isl\u00e1nd" },
            { "VN", "Wietn\u00e1m" },
            { "VU", "Wanu\u00e1tu" },
            { "WF", "W\u00e1lis o Futun\u00e1" },
            { "WS", "Sam\u00f3\u00e1" },
            { "XA", "Kes\u00e1si-G\u00e1lw\u00e1r" },
            { "XB", "Kes\u00e1si- Bidi" },
            { "XK", "K\u00f3s\u00f3w\u00f3" },
            { "YE", "Yaman" },
            { "YT", "Mayotte" },
            { "ZA", "Zerb\u00e1ri Aprik\u00e1" },
            { "ZM", "Zambi\u00e1" },
            { "ZW", "Zemb\u00e1bw\u00e9" },
            { "ZZ", "Nagisshetag\u00e9n damag" },
            { "aa", "Apar" },
            { "ab", "Abkh\u00e1zi" },
            { "af", "Aprik\u00e1i" },
            { "ak", "Akan" },
            { "am", "Amhari" },
            { "an", "Arag\u00f3ni" },
            { "ar", metaValue_ar },
            { "as", "As\u00e1mi" },
            { "az", "\u00c1zerb\u00e1ij\u00e1ni" },
            { "ba", "Bashkar" },
            { "be", "B\u00e9l\u00e1rusi" },
            { "bg", "Bolg\u00e1ri\u00e1i" },
            { "bm", "Bambar\u00e1" },
            { "bn", "Bang\u00e1li" },
            { "bo", "Tebbati" },
            { "br", "Br\u00e9t\u00f3n" },
            { "bs", "Busni\u00e1i" },
            { "ca", "Kat\u00e1lan" },
            { "ce", "Chechen" },
            { "co", "Korsiki" },
            { "cs", "Chek" },
            { "cu", "Charch Sl\u00e1wi" },
            { "cv", "Chuwash" },
            { "cy", "W\u00e9li" },
            { "da", "Denm\u00e1rki" },
            { "de", "Jarman" },
            { "dv", "Diw\u00e9hi" },
            { "dz", "Dzongk\u00e1" },
            { "ee", "Ewe" },
            { "el", "Yun\u00e1ni" },
            { "en", "Engr\u00e9zi" },
            { "eo", "Esper\u00e1ntu" },
            { "es", "Espini" },
            { "et", "Est\u00f3ni\u00e1i" },
            { "eu", "Bask" },
            { "fa", "P\u00e1rsi" },
            { "ff", "Pul\u00e1" },
            { "fi", "Fenl\u00e1ndi" },
            { "fo", "Par\u00f3ese" },
            { "fr", "Par\u00e1nsi" },
            { "fy", "Ferisi (R\u00f3barkati)" },
            { "ga", "\u00c1eri" },
            { "gd", "Esk\u00e1ti G\u00e9li" },
            { "gl", "Gal\u00e9ki" },
            { "gn", "Gu\u00e1ri\u00e1n" },
            { "gu", "Gojr\u00e1ti" },
            { "gv", "Manks" },
            { "ha", "Haus\u00e1" },
            { "he", metaValue_he },
            { "hi", "Hendi" },
            { "hr", "Kr\u00f3shi\u00e1i" },
            { "hu", "Hang\u00e1ri" },
            { "hy", "Armini\u00e1i" },
            { "ia", "My\u00e1nzob\u00e1ni" },
            { "id", "End\u00f3n\u00e9si" },
            { "ie", "My\u00e1nzob\u00e1n" },
            { "ig", "Igb\u00f3" },
            { "ii", "Sichu\u00e1i Yi" },
            { "io", "Id\u00f3" },
            { "is", "Isl\u00e1ndi" },
            { "it", "It\u00e1li\u00e1i" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "J\u00e1w\u00e1ni" },
            { "ka", "J\u00e1rji\u00e1i" },
            { "ki", "Kikuyu" },
            { "kk", "K\u00e1z\u00e1k" },
            { "kl", "Kal\u00e1llisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "Kuri\u00e1i" },
            { "ks", "Kashmiri" },
            { "ku", "Kordi" },
            { "kw", "Kornesh" },
            { "ky", "Kirgez" },
            { "la", "L\u00e1tini" },
            { "lb", "Logzemborgi" },
            { "lg", "Gand\u00e1" },
            { "ln", "Ling\u00e1l\u00e1" },
            { "lo", "L\u00e1\u00f3" },
            { "lt", "Litw\u00e1ni\u00e1i" },
            { "lu", "Lub\u00e1-Katang\u00e1" },
            { "lv", "Latwi\u00e1i" },
            { "mg", "Malagase" },
            { "mi", "Muri" },
            { "mk", "Makduni" },
            { "ml", metaValue_ml },
            { "mn", "Mang\u00f3li" },
            { "mr", "Mar\u00e1thi" },
            { "ms", "Malai" },
            { "mt", "Maltiz" },
            { "my", "Barm\u00e1i" },
            { "nb", "N\u00e1rwiji Bokm\u00e1l" },
            { "nd", "Shem\u00e1li Ned\u00e9b\u00e9le" },
            { "ne", "N\u00e9p\u00e1li" },
            { "nl", "Dacch" },
            { "nn", "N\u00e1rwiji N\u00f3k\u00e9n" },
            { "no", "N\u00e1rwiji" },
            { "nr", "Zerb\u00e1ri Nedeb\u00e9li" },
            { "nv", "Naw\u00e1j\u00f3" },
            { "ny", "Nyanj\u00e1" },
            { "oc", "Ositi" },
            { "om", "Orom\u00f3" },
            { "or", "Odi" },
            { "os", "Os\u00e9ti" },
            { "pa", "Panj\u00e1bi" },
            { "pl", "P\u00f3layndi" },
            { "ps", "Pasht\u00f3" },
            { "pt", "Portag\u00e1li" },
            { "qu", "Kwichu" },
            { "rm", "Rumansh" },
            { "rn", "R\u00f3ndi" },
            { "ro", "Rum\u00e1ni\u00e1i" },
            { "ru", metaValue_ru },
            { "rw", "Kenyarwand\u00e1" },
            { "sa", "Sanskeret" },
            { "sc", "Sard\u00e9ni\u00e1i" },
            { "sd", "Sendi" },
            { "se", "Shem\u00e1li S\u00e1mi" },
            { "sg", "Sang\u00f3" },
            { "si", "Senh\u00e1l\u00e1" },
            { "sk", "Solw\u00e1k" },
            { "sl", "Solwini\u00e1i" },
            { "sn", "Shon\u00e1" },
            { "so", "S\u00f3m\u00e1li" },
            { "sq", "Alb\u00e1ni\u00e1i" },
            { "sr", "Sarbi\u00e1i" },
            { "ss", "Sw\u00e1ti" },
            { "st", "Zerb\u00e1ri Sut\u00f3" },
            { "su", metaValue_su },
            { "sv", "Swidi" },
            { "sw", "Sw\u00e1h\u00e9li" },
            { "ta", metaValue_ta },
            { "te", "Telg\u00f3" },
            { "tg", "T\u00e1jek" },
            { "th", metaValue_th },
            { "ti", "Tigrini\u00e1" },
            { "tk", "Trkm" },
            { "tn", "Tusw\u00e1n\u00e1" },
            { "to", "Tongan" },
            { "tr", "Tork" },
            { "ts", "Tesung\u00e1" },
            { "tt", "T\u00e1tar" },
            { "ug", "Yughor" },
            { "uk", "Yukrini" },
            { "ur", "Urdu" },
            { "uz", "Ozbek" },
            { "ve", "Wend\u00e1" },
            { "vi", "Wietn\u00e1mi" },
            { "vo", "Wol\u00e1puk" },
            { "wa", "Wallun" },
            { "wo", "Wolop" },
            { "xh", "Khush\u00e1" },
            { "yi", "Yeddi" },
            { "yo", "Yorob\u00e1" },
            { "za", "Zhu\u00e1ng" },
            { "zh", "Chini" },
            { "zu", "Zulu" },
            { "agq", "Agem" },
            { "ann", "Ob\u00f3l\u00f3" },
            { "apc", "Latwi\u00e1i Arabi" },
            { "arn", "Mapuche" },
            { "asa", "Asu" },
            { "ast", "Asturi\u00e1i" },
            { "bal", "Bal\u00f3chi" },
            { "bas", "Bas\u00e1" },
            { "bem", "Bemb\u00e1" },
            { "bew", "Betawi" },
            { "bez", "Ben\u00e1" },
            { "bgc", "Hary\u00e1nui" },
            { "bgn", "Bal\u00f3chi (R\u00f3barkati)" },
            { "bho", "B\u00f3jpuri" },
            { "blo", "Ani" },
            { "blt", "T\u00e1i Dam" },
            { "brx", "Bod\u00f3" },
            { "bss", "Akuse" },
            { "byn", "Blin" },
            { "cad", "Kadd\u00f3-kad" },
            { "cch", "Atsam" },
            { "ccp", "Chakm\u00e1" },
            { "ceb", "Chebu\u00e1n\u00f3" },
            { "cgg", "Chig\u00e1" },
            { "cho", "Choktaw" },
            { "chr", "Cheruki" },
            { "cic", "Chekk\u00e1saw" },
            { "ckb", "My\u00e1ni Kordi" },
            { "csw", "Swampi Kri" },
            { "dav", "T\u00e1it\u00e1" },
            { "dje", "Zarmah" },
            { "doi", "Dogri" },
            { "dsb", "L\u00e1war Sorbi" },
            { "dua", "Du\u00e1l\u00e1" },
            { "dyo", "J\u00f3l\u00e1-P\u00f3ni" },
            { "ebu", "Emb\u00f3" },
            { "ewo", "Ewond\u00f3" },
            { "fil", "Pelpini" },
            { "frc", "K\u00e1jon Pr\u00e1nsi" },
            { "frr", "Shem\u00e1li Pr\u00e9si" },
            { "fur", "Priuli" },
            { "gaa", "Gaa" },
            { "gez", "G\u00e9z" },
            { "gsw", "Swiz Jarman" },
            { "guz", "Gusi" },
            { "haw", "Haw\u00e1i" },
            { "hnj", "Hmang Nju\u00e1" },
            { "hsb", "Borzi Sorbi\u00e1i" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomb\u00e1" },
            { "jmc", "Makami" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kab\u00e1ile" },
            { "kaj", "Jju" },
            { "kam", "Kamb\u00e1" },
            { "kcg", "Ty\u00e1p" },
            { "kde", "Makonde" },
            { "kea", "Kubuwerdi\u00e1n\u00f3" },
            { "ken", "Kinyang" },
            { "kgp", "K\u00e1ing\u00e1ng" },
            { "khq", "Koir\u00e1 Chini" },
            { "kkj", "K\u00e1k\u00f3" },
            { "kln", "Kalenjin" },
            { "kok", "Konkani" },
            { "kpe", "Kpelle" },
            { "ksb", "Shambal\u00e1" },
            { "ksf", "Bapi\u00e1" },
            { "ksh", "Kologni" },
            { "kxv", "Kuwi" },
            { "lag", "Langi" },
            { "lij", "Liguri" },
            { "lkt", "Lak\u00f3t\u00e1" },
            { "lld", "Ladin" },
            { "lmo", "Lombard" },
            { "lou", "Luisi\u00e1n\u00e1 Kri\u00f3le" },
            { "lrc", "Shem\u00e1li Lori" },
            { "ltg", "Latgali" },
            { "luo", "Lu\u00f3" },
            { "luy", "Lui\u00e1" },
            { "mai", "Mait\u00e9li" },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "mer", "M\u00e9ru" },
            { "mfe", "Muris\u00e9n" },
            { "mgh", "Maku\u00e1-Mit\u00f3" },
            { "mgo", "M\u00e9t\u00e1" },
            { "mhn", "M\u00f3ch\u00e9n\u00f3" },
            { "mic", "Mikmaw" },
            { "mni", "Manipuri" },
            { "moh", "Mohawk" },
            { "mua", "Mundang" },
            { "mul", "B\u00e1z zob\u00e1n" },
            { "mus", "Musk\u00f3gi" },
            { "myv", "Erzi\u00e1" },
            { "mzn", "M\u00e1zendar\u00e1ni" },
            { "naq", "Nama" },
            { "nds", "L\u00e1w Jarman" },
            { "nmg", "Kw\u00e1siu" },
            { "nnh", "Ngembun" },
            { "nqo", "Nko" },
            { "nso", "Shem\u00e1li Sot\u00f3" },
            { "nus", "Nu\u00e9r" },
            { "nyn", "Nyank\u00f3le" },
            { "osa", "Os\u00e1g\u00e1" },
            { "pap", "P\u00e1pi\u00e1ment\u00f3" },
            { "pcm", "N\u00e1ijiri Pidgin" },
            { "pis", "Pijen" },
            { "prg", "Prushi\u00e1i" },
            { "quc", "Kichi" },
            { "raj", "R\u00e1jest\u00e1ni" },
            { "rhg", "R\u00f3hengi\u00e1" },
            { "rif", "Ripi" },
            { "rof", "Romb\u00f3" },
            { "rwk", "Rwa" },
            { "sah", "Yakut" },
            { "saq", "Sambor\u00f3" },
            { "sat", "Santali" },
            { "sbp", "Sangu" },
            { "scn", "Sesili\u00e1i" },
            { "sdh", "Zerb\u00e1ri Kordi" },
            { "seh", "Sen\u00e1" },
            { "ses", "Kory\u00e1bur\u00f3 Senni" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "sid", "Sid\u00e1m\u00f3" },
            { "skr", "Sar\u00e1eki" },
            { "sma", "Zerb\u00e1ri S\u00e1mi" },
            { "smj", "Lule S\u00e1mi" },
            { "smn", "In\u00e1ri S\u00e1mi" },
            { "sms", "Esk\u00e1lt S\u00e1mi" },
            { "ssy", metaValue_ssy },
            { "syr", metaValue_syr },
            { "szl", "Selisi" },
            { "teo", "T\u00e9s\u00f3" },
            { "tig", "Tigr\u00e9" },
            { "tok", "T\u00f3ki P\u00f3n\u00e1" },
            { "tpi", "Tok Pisin" },
            { "trv", "Torok\u00f3" },
            { "trw", "Torw\u00e1li" },
            { "twq", "Tasawak" },
            { "tyv", "Tuwini" },
            { "tzm", "Tzm" },
            { "und", "Nagisshetag\u00e9n zob\u00e1n" },
            { "vai", metaValue_vai },
            { "vec", "Weneti" },
            { "vmw", "Makuw\u00e1" },
            { "vun", "Wunj\u00f3" },
            { "wae", "Welser" },
            { "wal", "Wolett\u00e1" },
            { "wbp", "Warlpiri" },
            { "xnr", "Kangri" },
            { "xog", "Sug\u00e1" },
            { "yav", "Yangben" },
            { "yrl", "Ning\u00e1tu" },
            { "yue", "Kant\u00f3ni" },
            { "zgh", "Gisshetqag\u00e9n Mor\u00f3ki Tam\u00e1zi" },
            { "zxx", "Hecch zob\u00e1n" },
            { "Adlm", "Adlam" },
            { "Aghb", "K\u00e1k\u00e1shi Alb\u00e1ni" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastalik" },
            { "Armi", "Shahensh\u00e1hi Aram\u00e1i" },
            { "Armn", "Arman" },
            { "Avst", "Awest\u00e1i" },
            { "Bali", "B\u00e1l\u00e9ni" },
            { "Bamu", "B\u00e1mum" },
            { "Bass", "Bassa Wah" },
            { "Batk", "Batak" },
            { "Beng", "Bang" },
            { "Bhks", "Baykduki" },
            { "Bopo", "B\u00f3p\u00f3" },
            { "Brah", "Brahmi" },
            { "Brai", "Br\u00e1i" },
            { "Bugi", "Bugini" },
            { "Buhd", "Buhid" },
            { "Cakm", "Chakma" },
            { "Cans", "Kaynadh\u00e1i Aslig\u00e9n Sil\u00e1bi" },
            { "Cari", "Charian" },
            { "Cher", "Cheoki" },
            { "Chrs", "Chorasmi" },
            { "Copt", "koptek" },
            { "Cpmn", "S\u00e1epr\u00f3-Min\u00f3i" },
            { "Cprt", "S\u00e1epri\u00f3t" },
            { "Cyrl", metaValue_ru },
            { "Cyrs", "Ahdi Serelek" },
            { "Deva", "D\u00e9w\u00e1" },
            { "Diak", "Diwes Akuru" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duplui Sh\u00e1rthand" },
            { "Egyp", "Mesri hir\u00f3gleps" },
            { "Elba", "Elb\u00e1si" },
            { "Elym", "\u00c9lim\u00e1i" },
            { "Ethi", "Etyupi" },
            { "Gara", "Garay" },
            { "Geor", "J\u00e1rj" },
            { "Glag", "Galgoliti" },
            { "Gong", "Gunj\u00e1la G\u00f3ndi" },
            { "Gonm", "Mas\u00e1ram G\u00f3ndi" },
            { "Goth", "G\u00f3ti" },
            { "Gran", "Grant\u00e1" },
            { "Grek", "Yun" },
            { "Gujr", "Gojr" },
            { "Gukh", "Gurong Kh\u00e9m\u00e1" },
            { "Guru", "Gurukuki" },
            { "Hanb", "H\u00e1n g\u00f3n B\u00f3p\u00f3m\u00f3p\u00f3\u00e1" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunu" },
            { "Hans", "H\u00e1n (s\u00e1dah kortag\u00e9n)" },
            { "Hant", "H\u00e1n (aslig\u00e9n)" },
            { "Hatr", "Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "Hir\u00e1g\u00e1n\u00e1" },
            { "Hluw", "An\u00e1t\u00f3ly\u00e1i H\u00e9r\u00f3gleps" },
            { "Hmng", "Pahaw Hmong" },
            { "Hmnp", "Ni\u00e1keng Pu\u00e1che Hamung" },
            { "Hrkt", "J\u00e1p\u00e1ni Selibari" },
            { "Hung", "Ahdi Hangari" },
            { "Ital", "Ahdi It\u00e1li\u00e1i" },
            { "Jamo", "Jam\u00f3" },
            { "Java", "J\u00e1w\u00e1" },
            { "Jpan", metaValue_ja },
            { "Kali", "K\u00e1yah Li" },
            { "Kana", "Katakan\u00e1" },
            { "Kawi", "K\u00e1wi" },
            { "Khar", "Kar\u00f3shti" },
            { "Khmr", metaValue_km },
            { "Khoj", "K\u00f3jki" },
            { "Kits", "Kitan gwandh\u00e9n sy\u00e1hag" },
            { "Knda", metaValue_kn },
            { "Kore", "K\u00f3ri\u00e1i" },
            { "Krai", "Kirat Rai" },
            { "Kthi", "Kaiti" },
            { "Lana", "Lann\u00e1" },
            { "Laoo", "L\u00e1u" },
            { "Latf", "Praktur L\u00e1tin" },
            { "Latg", "G\u00e9li L\u00e1tin" },
            { "Latn", "L\u00e1tin Engr\u00e9zi (L\u00e1tin) Engr\u00e9zi (L\u00e1tin, Amrik\u00e1ay Tep\u00e1k\u00e9n Est\u00e1n) sy\u00e1hag: L\u00e1tini" },
            { "Lepc", "Lepch\u00e1" },
            { "Limb", "Limbu" },
            { "Lina", "Layni A" },
            { "Linb", "Layni B" },
            { "Lisu", "Pr\u00e1sar" },
            { "Lyci", "Lisi\u00e1i" },
            { "Lydi", "Lidi\u00e1i" },
            { "Mahj", "Mah\u00e1jani" },
            { "Maka", "Makasar" },
            { "Mand", "Mand\u00e1in" },
            { "Mani", "Manich\u00e1i" },
            { "Marc", "Marchen" },
            { "Medf", "Medep\u00e1idrin" },
            { "Mend", "Mende" },
            { "Merc", "Meriuti Karsi" },
            { "Mero", "Meriuti" },
            { "Mlym", metaValue_ml },
            { "Modi", "M\u00f3di" },
            { "Mong", "Mong\u00f3li" },
            { "Mroo", "Mr\u00f3" },
            { "Mtei", "Miyeti M\u00e1yek" },
            { "Mult", "Molt\u00e1ni" },
            { "Mymr", "Myanm\u00e1r" },
            { "Nagm", "Nag Mundari" },
            { "Nand", "Nandinagari" },
            { "Narb", "Ahdi Shem\u00e1li Arabi" },
            { "Nbat", "Nabat\u00e1i" },
            { "Newa", "New\u00e1" },
            { "Nkoo", "Nek\u00f3" },
            { "Nshu", "Nushu" },
            { "Ogam", "Ogh\u00e1m" },
            { "Olck", "Ol cheki" },
            { "Onao", "Ol Onal" },
            { "Orkh", "Orkhon" },
            { "Orya", "\u00d3di\u00e1" },
            { "Osge", "Os\u00e9j" },
            { "Osma", "Osm\u00e1nia" },
            { "Ougr", "Ahdi Y\u00f3gher" },
            { "Palm", "Palmr\u00e9n" },
            { "Pauc", "P\u00e1u Chen H\u00e1u" },
            { "Perm", "Ahdi Permi" },
            { "Phag", "Pags-pa" },
            { "Phli", "Kondahi Pahlawi" },
            { "Phlp", "Ps\u00e1ltar Pahlawi" },
            { "Phnx", "Ph\u00f3nisi" },
            { "Plrd", "P\u00f3lli Taw\u00e1ri" },
            { "Prti", "Kondahi P\u00e1rti" },
            { "Qaag", "Zawgi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanipi" },
            { "Runr", "Runi" },
            { "Samr", "Sam\u00e1ri" },
            { "Sarb", "Ahdi Zerb\u00e1ri Arabi" },
            { "Saur", "S\u00e1ur\u00e1shtri" },
            { "Sgnw", "Nesh\u00e1nnebisi" },
            { "Shaw", "Sh\u00e1wi" },
            { "Shrd", "Sharad\u00e1" },
            { "Sidd", "Seddam" },
            { "Sind", "Kod\u00e1wadi" },
            { "Sinh", "Senhal\u00e1" },
            { "Sogd", "S\u00f3gdi\u00e1i" },
            { "Sogo", "Ahdi S\u00f3gdi\u00e1i" },
            { "Sora", "Sur\u00e1 Sompeng" },
            { "Soyo", "Soyomb\u00f3" },
            { "Sund", metaValue_su },
            { "Sunu", "Sunuwar" },
            { "Sylo", "Siluti Nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "Estrangl\u00f3 Siriek" },
            { "Syrj", "R\u00f3nendi Siriek" },
            { "Syrn", "R\u00f3dar\u00e1tki Siriek" },
            { "Tagb", "Tagbanw\u00e1" },
            { "Takr", "Takri" },
            { "Tale", "T\u00e1i L\u00e9" },
            { "Talu", "N\u00f3k\u00e9n T\u00e1i L\u00e9" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "T\u00e1i Wiet" },
            { "Telu", "Teleg\u00f3" },
            { "Tfng", "Tipinag" },
            { "Tglg", "Tagalog" },
            { "Thaa", "T\u00e1na" },
            { "Thai", metaValue_th },
            { "Tibt", "Tebati" },
            { "Tirh", "Tirhut\u00e1" },
            { "Tnsa", "Tangs\u00e1" },
            { "Todr", "T\u00f3dri" },
            { "Toto", "T\u00f3t\u00f3" },
            { "Tutg", "Tulu-Tig\u00e1lari" },
            { "Ugar", "Yugariti" },
            { "Vaii", metaValue_vai },
            { "Vith", "Witkuki" },
            { "Wara", "Warang Kshiti" },
            { "Wcho", "Wanch\u00f3" },
            { "Xpeo", "Ahdi P\u00e1rsi" },
            { "Xsux", "Sumer-Ak\u00e1di Kyunip\u00e1rm" },
            { "Yezi", "Yezidi" },
            { "Yiii", "Yi" },
            { "Zanb", "Zanabazar Eskw\u00e1er" },
            { "Zinh", "Enheri" },
            { "Zmth", "Hes\u00e1bi Nesh\u00e1n" },
            { "Zsye", "Em\u00f3ji" },
            { "Zsym", "Nesh\u00e1n" },
            { "Zxxx", "Nebeshtah nabutag\u00e9n sy\u00e1hag" },
            { "Zyyy", "H\u00f3r\u00e9n" },
            { "Zzzz", "K\u00f3dh nakortag\u00e9n sy\u00e1hag" },
            { "en_CA", "Engr\u00e9zi (Kaynadh\u00e1)" },
            { "es_MX", "Espini (Meksik\u00f3)" },
            { "fa_AF", "P\u00e1rsi (AF)" },
            { "fr_CA", "Par\u00e1nsi (Kaynadh\u00e1)" },
            { "nl_BE", "Dacch (B\u00e9ljiam)" },
            { "ro_MD", "Rum\u00e1ni\u00e1i (MD)" },
            { "sw_CD", "Sw\u00e1h\u00e9li (CD)" },
            { "%%1901", "Rabyati Jarman nebeshtarahband" },
            { "%%1994", "Gisshetag\u00e9n R\u00e9shian nebeshtarahband" },
            { "%%1996", "Jarman nebeshtarahband" },
            { "ar_001", "Arabi (Dony\u00e1)" },
            { "es_419", "Espini (L\u00e1tini Amrik\u00e1)" },
            { "key.ca", "S\u00e1ldar" },
            { "key.cf", "Zarr K\u00e1leb" },
            { "key.co", "Red o band" },
            { "key.cu", "Zarr" },
            { "key.hc", "S\u00e1hat\u00e1ni chahr (12 o 24)" },
            { "key.lb", "Red pr\u00f3shagay d\u00e1b" },
            { "key.ms", "Kayl kanagy rahband" },
            { "key.nu", "Nambar" },
            { "nds_NL", "L\u00e1w Jarman (NL)" },
            { "%%ALUKU", "Aluku g\u00e1lw\u00e1r" },
            { "%%BARLA", "Barlawent\u00f3 g\u00e1lw\u00e1r granch, K\u00e1buwerdi\u00e1nu" },
            { "%%BCIAV", "BKIAW" },
            { "%%BISKE", "San Ji\u00e1rj\u00f3/Bila g\u00e1lw\u00e1r" },
            { "%%BLASL", "BL\u00c1SL" },
            { "%%BOONT", "Buntleng" },
            { "%%CORNU", "C\u00d3RNU" },
            { "%%FODOM", "FOD\u00d3M" },
            { "%%GALLO", "GALL\u00d3" },
            { "%%GHERD", "GH\u00c9RD" },
            { "%%JAUER", "J\u00c1U\u00c9R" },
            { "%%KKCOR", "Haw\u00e1r\u00e9n Nebeshtarahband" },
            { "%%KSCOR", "Gisshetag\u00e9n Nebeshtarahband" },
            { "%%LIPAW", "Lip\u00f3w\u00e1zi g\u00e1lw\u00e1r, R\u00e9shi" },
            { "%%NEDIS", "Natis\u00f3n g\u00e1lw\u00e1r" },
            { "%%NJIVA", "Gniw\u00e1/Njiw\u00e1 g\u00e1lw\u00e1r" },
            { "%%NULIK", "N\u00f3k\u00e9n Wol\u00e1puk" },
            { "%%OSOJS", "Osi\u00e1kk\u00f3/Os\u00f3j\u00e1n\u00e9 g\u00e1lw\u00e1r" },
            { "%%PEANO", "PE\u00c1N\u00d3" },
            { "%%POSIX", "Kampyutar" },
            { "%%PUTER", "PUT\u00c9R" },
            { "%%RIGIK", "Kal\u00e1siki W\u00f3l\u00e1puk" },
            { "%%ROZAJ", "R\u00e9shi" },
            { "%%RUMGR", "R\u00d3MGR" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Stolwiz\u00e1/Solbik\u00e1 g\u00e1lw\u00e1r" },
            { "%%SOTAV", "Sot\u00e1went\u00f3 g\u00e1lw\u00e1r granch, Kabuwerdi\u00e1n\u00f3" },
            { "%%TAILO", "T\u00c1IL\u00d3" },
            { "%%UCCOR", "Hamshawr\u00e9n Nebeshtarahband" },
            { "hi_Latn", "Hendi (L\u00e1tin Engr\u00e9zi (L\u00e1tin) Engr\u00e9zi (L\u00e1tin, Amrik\u00e1ay Tep\u00e1k\u00e9n Est\u00e1n) sy\u00e1hag: L\u00e1tini)" },
            { "%%ANPEZO", "ANP\u00c9Z\u00d3" },
            { "%%AO1990", "Portog\u00e1li Zob\u00e1nay Nebeshtarahbanday Mann\u00e1nk 1990" },
            { "%%ARANES", "ARAN\u00c9S" },
            { "%%ASANTE", "ASANT\u00c9" },
            { "%%AUVERN", "AUWERN" },
            { "%%BCIZBL", "BKIZBL" },
            { "%%CISAUP", "CIS\u00c1UP" },
            { "%%CREISS", "CR\u00c9ISS" },
            { "%%DAJNKO", "Dajank\u00f3 \u00e1b" },
            { "%%EKAVSK", "Sarbi\u00e1i g\u00f3n Ekw\u00e1i g\u00e1lw\u00e1r\u00e1" },
            { "%%FASCIA", "F\u00c1SCI\u00c1" },
            { "%%FONIPA", "IPA Taw\u00e1ri" },
            { "%%FONUPA", "UPA Taw\u00e1ri" },
            { "%%GASCON", "GASK\u00d3N" },
            { "%%GRITAL", "GRIT\u00c1L" },
            { "%%NDYUKA", "Ndyuk\u00e1 g\u00e1lw\u00e1r" },
            { "%%NICARD", "NIC\u00c1RD" },
            { "%%PAMAKA", "Pam\u00e1k\u00e1 g\u00e1lw\u00e1r" },
            { "%%PINYIN", "Pinyin L\u00e1tini" },
            { "%%SCOUSE", "Sk\u00e1uz" },
            { "%%SIMPLE", "S\u00e1dah" },
            { "%%TARASK", "Taraskiwik\u00e1 nebeshtarahband" },
            { "%%UCRCOR", "Hamshawr\u00e9n N\u00f3k\u00e1z\u00e9n Nebeshtarahband" },
            { "%%ULSTER", "ULST\u00c9R" },
            { "%%UNIFON", "UNIFON-taw\u00e1ri \u00e1b" },
            { "bal_Latn", "Bal\u00f3chi (L\u00e1tin)" },
            { "%%ABL1943", "Nebeshtarahbnadi Gishw\u00e1r 1943" },
            { "%%AKUAPEM", "AKU\u00c1P\u00c9M" },
            { "%%ALALC97", "ALA-LK L\u00e1tini, 1997" },
            { "%%ARKAIKA", "ARK\u00c1IK\u00c1" },
            { "%%BALANKA", "Balank\u00e1 g\u00e1lw\u00e1r, Anii" },
            { "%%BAUDDHA", "BAUDD\u00c1" },
            { "%%BOHORIC", "Boh\u00f3ri \u00e1b" },
            { "%%EMODENG", "Mahlah\u00e9n N\u00f3k\u00e9n Engr\u00e9zi" },
            { "%%FONNAPA", "FONN\u00c1P\u00c1" },
            { "%%GRCLASS", "GRKL\u00c1SS" },
            { "%%GRMISTR", "GRMEST" },
            { "%%HEPBURN", "Hepburn L\u00e1tini" },
            { "%%ITIHASA", "ITIH\u00c1S\u00c1" },
            { "%%LAUKIKA", "L\u00c1UKIK\u00c1" },
            { "%%LEMOSIN", "L\u00c9M\u00d3SIN" },
            { "%%LTG1929", "LTG-1929" },
            { "%%LTG2007", "LTG-2007" },
            { "%%METELKO", "Metelk\u00f3 \u00e1b" },
            { "%%MONOTON", "M\u00f3n\u00f3t\u00e1ni" },
            { "%%PAHAWH2", "PAHAWH-2" },
            { "%%PAHAWH3", "PAHAWH-3" },
            { "%%PAHAWH4", "PAHAWH-4" },
            { "%%PEHOEJI", "PEH\u00d3EJI" },
            { "%%POLYTON", "P\u00f3lituni" },
            { "%%PROVENC", "PROWENC" },
            { "%%REVISED", "N\u00f3k\u00e1z\u00e9n Nebeshtarahband" },
            { "%%SURSILV", "SURSILW" },
            { "%%SUTSILV", "SUTSILW" },
            { "%%VAIDIKA", "WAIDIKA" },
            { "%%1606NICT", "Randi My\u00e1ni Pr\u00e1nsi" },
            { "%%1694ACAD", "Mahlah\u00e9n N\u00f3k\u00e9n Pr\u00e1nsi" },
            { "%%1959ACAD", "Ak\u00e1demi" },
            { "%%BAKU1926", "Haw\u00e1r\u00e9n Torki L\u00e1tini \u00c1b" },
            { "%%BASICENG", "BASIKENG" },
            { "%%BISCAYAN", "BISKAYAN" },
            { "%%BORNHOLM", "B\u00d3RNHOLM" },
            { "%%COLB1945", "Portag\u00e9zi-Br\u00e1zili Nebeshtarahband Diw\u00e1n 1945" },
            { "%%FONKIRSH", "F\u00d3NKERSH" },
            { "%%FONXSAMP", "FONKSAMP" },
            { "%%HOGNORSK", "H\u00d3GN\u00d3RSK" },
            { "%%HSISTEMO", "HSISTEM\u00d3" },
            { "%%IJEKAVSK", "Sarbi\u00e1i g\u00f3n Ejekaw\u00e1i g\u00e1lw\u00e1r\u00e1" },
            { "%%IVANCHOV", "IWANCH\u00d3W" },
            { "%%JYUTPING", "JYUTP\u00c9NG" },
            { "%%KOCIEWIE", "K\u00d3CIEWI\u00c9" },
            { "%%LENGADOC", "LENG\u00c1D\u00d3K" },
            { "%%LUNA1918", "LUN\u00c1-1918" },
            { "%%NEWFOUND", "NEWPOUND" },
            { "%%OXENDICT", "\u00c1ksp\u00f3rd Engr\u00e9zi Labzbaladay \u00e1p rahband" },
            { "%%PETR1708", "P\u00c9TR-1708" },
            { "%%SCOTLAND", "Esk\u00e1ti Gisshetag\u00e9n Engr\u00e9zi" },
            { "%%SPANGLIS", "SP\u00c1NGLIS" },
            { "%%SURMIRAN", "SURMIR\u00c1N" },
            { "%%SYNNEJYL", "SYNN\u00c9JYL" },
            { "%%TONGYONG", "TONGY\u00d3NG" },
            { "%%TUNUMIIT", "TUNUMI\u00c9T" },
            { "%%VALBADIA", "WALBADI\u00c1" },
            { "%%VALENCIA", "Walensi" },
            { "%%VALLADER", "WALLADER" },
            { "%%VECDRUKA", "\u00d3ECDRUK\u00c1" },
            { "%%VIVARAUP", "WIWAR\u00c1UP" },
            { "%%WADEGILE", "Wayd-Gili L\u00e1tin" },
            { "%%XSISTEMO", "KSISTEMO" },
            { "type.ca.roc", "Mingu-Chini s\u00e1ldar" },
            { "type.co.eor", "Yuropi Red o bandi Rahband" },
            { "type.hc.h11", "12 S\u00e1hati (0\u201311)" },
            { "type.hc.h12", "12 S\u00e1hati (1\u201312)" },
            { "type.hc.h23", "24 S\u00e1hati (0\u201323)" },
            { "type.hc.h24", "14 S\u00e1hati (1\u201324)" },
            { "type.nu.ahom", "Ahom M\u00f3rd\u00e1n" },
            { "type.nu.arab", "Arabi-Hendi m\u00f3rd\u00e1n" },
            { "type.nu.armn", "\u00c1rmini Nambar" },
            { "type.nu.bali", "B\u00e1l\u00e9ni M\u00f3rd\u00e1n" },
            { "type.nu.beng", "Bangla M\u00f3rd\u00e1n" },
            { "type.nu.brah", "Brahmi M\u00f3rd\u00e1n" },
            { "type.nu.cakm", "Chakma M\u00f3rd\u00e1n" },
            { "type.nu.cham", "Cham M\u00f3rd\u00e1n" },
            { "type.nu.cyrl", "Rusi m\u00f3rd\u00e1n" },
            { "type.nu.deva", "D\u00e9n\u00e1gari m\u00f3rd\u00e1n" },
            { "type.nu.diak", "Diwi Akuru M\u00f3rd\u00e1n" },
            { "type.nu.ethi", "Etupi Nambar" },
            { "type.nu.gara", "Garai M\u00f3rd\u00e1n" },
            { "type.nu.geor", "J\u00e1rji\u00e1i Nambar" },
            { "type.nu.gong", "Gunj\u00e1la G\u00f3ndi m\u00f3rd\u00e1n" },
            { "type.nu.gonm", "Masaram G\u00f3ndi m\u00f3rd\u00e1n" },
            { "type.nu.grek", "Yun\u00e1ni Nambar" },
            { "type.nu.gujr", "Gojr\u00e1ti M\u00f3rd\u00e1n" },
            { "type.nu.gukh", "Gurong Kh\u00e9m\u00e1 M\u00f3rd\u00e1n" },
            { "type.nu.guru", "Gurmuki M\u00f3rd\u00e1n" },
            { "type.nu.hans", "S\u00e1da kortag\u00e9n Chini Nambar" },
            { "type.nu.hant", "Chini Rabyati Nambar" },
            { "type.nu.hebr", "Ebr\u00e1ni Nambar" },
            { "type.nu.hmng", "Pahaw Hmong M\u00f3rd\u00e1n" },
            { "type.nu.hmnp", "Ny\u00e1keng P\u00e1uch\u00f3 Hmong M\u00f3rd\u00e1n" },
            { "type.nu.java", "J\u00e1w\u00e1ni M\u00f3rd\u00e1n" },
            { "type.nu.jpan", "J\u00e1p\u00e1ni Nambar" },
            { "type.nu.kali", "K\u00e1yah Li M\u00f3rd\u00e1n" },
            { "type.nu.kawi", "Kawi M\u00f3rd\u00e1n" },
            { "type.nu.khmr", "Khm\u00e9r M\u00f3rd\u00e1n" },
            { "type.nu.knda", "Kannad\u00e1i M\u00f3rd\u00e1n" },
            { "type.nu.krai", "Kirat Rai M\u00f3rd\u00e1n" },
            { "type.nu.lana", "Tai Tam H\u00f3r\u00e1 M\u00f3rd\u00e1n" },
            { "type.nu.laoo", "L\u00e1\u00f3 M\u00f3rd\u00e1n" },
            { "type.nu.latn", "R\u00f3nendi M\u00f3rd\u00e1n" },
            { "type.nu.lepc", "Lepcha M\u00f3rd\u00e1n" },
            { "type.nu.limb", "Limbu M\u00f3rd\u00e1n" },
            { "type.nu.mlym", "Maly\u00e1lam M\u00f3rd\u00e1n" },
            { "type.nu.modi", "M\u00f3di M\u00f3rd\u00e1n" },
            { "type.nu.mong", "Mong\u00f3li M\u00f3rd\u00e1n" },
            { "type.nu.mroo", "Mr\u00f3 M\u00f3rd\u00e1n" },
            { "type.nu.mtei", "M\u00e9ti May\u00e9k M\u00f3rd\u00e1n" },
            { "type.nu.mymr", "My\u00e1nm\u00e1r M\u00f3rd\u00e1n" },
            { "type.nu.nagm", "Nag Mundari M\u00f3rd\u00e1n" },
            { "type.nu.nkoo", "Nk\u00f3 M\u00f3rd\u00e1n" },
            { "type.nu.olck", "Ol Cheki M\u00f3rd\u00e1n" },
            { "type.nu.onao", "Ol Onal M\u00f3rd\u00e1n" },
            { "type.nu.orya", "Odi M\u00f3rd\u00e1n" },
            { "type.nu.osma", "Osm\u00e1ni\u00e1i M\u00f3rd\u00e1n" },
            { "type.nu.rohg", "Hanipi R\u00f3hangi\u00e1i M\u00f3rd\u00e1n" },
            { "type.nu.saur", "Saurashtri M\u00f3rd\u00e1n" },
            { "type.nu.shrd", "Sharad\u00e1 M\u00f3rd\u00e1n" },
            { "type.nu.sind", "Kod\u00e1wadi M\u00f3rd\u00e1n" },
            { "type.nu.sinh", "Senh\u00e1l\u00e1 Lit M\u00f3rd\u00e1n" },
            { "type.nu.sora", "S\u00f3r\u00e1 Sompeng M\u00f3rd\u00e1n" },
            { "type.nu.sund", "Sud\u00e1ni M\u00f3rd\u00e1n" },
            { "type.nu.sunu", "Sunuwar M\u00f3rd\u00e1n" },
            { "type.nu.takr", "Takri M\u00f3rd\u00e1n" },
            { "type.nu.talu", "N\u00f3k\u00e9n Tai Lue M\u00f3rd\u00e1n" },
            { "type.nu.taml", "Rabyati T\u00e1mel Nambar" },
            { "type.nu.telu", "Teleg\u00f3 M\u00f3rd\u00e1n" },
            { "type.nu.thai", "T\u00e1i M\u00f3rd\u00e1n" },
            { "type.nu.tibt", "Tebbati M\u00f3rd\u00e1n" },
            { "type.nu.tirh", "Tirut\u00e1 M\u00f3rd\u00e1n" },
            { "type.nu.tnsa", "Tangs\u00e1 M\u00f3rd\u00e1n" },
            { "type.nu.vaii", "W\u00e1i M\u00f3rd\u00e1n" },
            { "type.nu.wara", "Warang Siti M\u00f3rd\u00e1n" },
            { "type.nu.wcho", "Wanch\u00f3 M\u00f3rd\u00e1n" },
            { "type.ca.dangi", "D\u00e1ngi s\u00e1ldar" },
            { "type.co.ducet", "Asl\u00e9n Yunikodi Red o band" },
            { "type.co.emoji", "Em\u00f3ji Red o band" },
            { "type.lb.loose", "Red pr\u00f3shagay shol\u00e9n d\u00e1b" },
            { "type.nu.roman", "L\u00e1tini Nambar" },
            { "type.ca.coptic", "Kobti s\u00e1ldar" },
            { "type.ca.hebrew", "Ebr\u00e1ni s\u00e1ldar" },
            { "type.ca.indian", "Hendi Kawmi s\u00e1ldar" },
            { "type.co.compat", "P\u00e9sari Red o band, pa hamdapi\u00e1" },
            { "type.co.pinyin", "Pinyi Red o band" },
            { "type.co.search", "\u00c1m K\u00e1ri Sh\u00f3h\u00e1z" },
            { "type.co.stroke", "Str\u00f3k Red o band" },
            { "type.co.unihan", "Trond\u00e9n-str\u00f3ki Red o band" },
            { "type.co.zhuyin", "Zhuin Red o band" },
            { "type.lb.normal", "Red pr\u00f3shagay \u00e1mig\u00e9n d\u00e1b" },
            { "type.lb.strict", "Red pr\u00f3shagay trond\u00e9n d\u00e1b" },
            { "type.ms.metric", "Mitari" },
            { "type.ca.chinese", "Chini s\u00e1ldar" },
            { "type.ca.islamic", "Esl\u00e1mi s\u00e1ldar" },
            { "type.ca.iso8601", "ISO-8601 s\u00e1ldar" },
            { "type.ca.persian", "P\u00e1rsi s\u00e1ldar" },
            { "type.cf.account", "Hes\u00e1b, Zarr K\u00e1leb" },
            { "type.co.big5han", "Chini Rabyati Red o band" },
            { "type.nu.arabext", "G\u00e9sh\u00e9n Arabi-Hendi M\u00f3rd\u00e1n" },
            { "type.nu.armnlow", "\u00c1rmini\u00e1i Kas\u00e1n\u00e9n Nambar" },
            { "type.nu.greklow", "Yun\u00e1ni Kas\u00e1n\u00e9n Nambar" },
            { "type.nu.hanidec", "Chini Dahi Nambar" },
            { "type.nu.hansfin", "S\u00e1da kortag\u00e9n Chini Hes\u00e1bi Nambar" },
            { "type.nu.hantfin", "Chini Rabyati Hes\u00e1ni Nambar" },
            { "type.nu.jpanfin", "J\u00e1p\u00e1ni Hes\u00e1bi Nambar" },
            { "type.nu.mathdbl", "Hes\u00e1bi do-likki M\u00f3rd\u00e1n" },
            { "type.nu.mymrpao", "My\u00e1nm\u00e1r Pao M\u00f3rd\u00e1n" },
            { "type.nu.tamldec", "T\u00e1mel M\u00f3rd\u00e1n" },
            { "type.ca.buddhist", "Budd\u00e1i s\u00e1ldar" },
            { "type.ca.ethiopic", "Etupi\u00e1i s\u00e1ldar" },
            { "type.ca.japanese", "J\u00e1p\u00e1ni s\u00e1ldar" },
            { "type.cf.standard", "Zarray anj\u00e1r\u00e9n k\u00e1leb" },
            { "type.co.searchjl", "Hangul Awali Jw\u00e1n\u00e1bay sar\u00e1 sh\u00f3h\u00e1z" },
            { "type.co.standard", "Anj\u00e1ri Red o band" },
            { "type.ms.uksystem", "Sh\u00e1hensh\u00e1hi Kayl Rahband" },
            { "type.ms.ussystem", "Amrik\u00e1i Kayl Rahband" },
            { "type.nu.fullwide", "Srjam-Sh\u00e1heg\u00e1n\u00e9n M\u00f3rd\u00e1n" },
            { "type.nu.lanatham", "Tai Tam Tam M\u00f3rd\u00e1n" },
            { "type.nu.mathbold", "Hes\u00e1bi Dhalag\u00e9n M\u00f3rd\u00e1n" },
            { "type.nu.mathmono", "Hes\u00e1bi Yakj\u00e1h\u00e9n M\u00f3rd\u00e1n" },
            { "type.nu.mathsanb", "Hes\u00e1bi Sans-Ser\u00e9p Dhalag\u00e9n M\u00f3rd\u00e1n" },
            { "type.nu.mathsans", "Hes\u00e1bi Sans-Ser\u00e9p M\u00f3rd\u00e1n" },
            { "type.nu.mymrepka", "My\u00e1nm\u00e1r R\u00f3dar\u00e1tki Pwo Karen M\u00f3rd\u00e1n" },
            { "type.nu.mymrshan", "My\u00e1nm\u00e1r Shan M\u00f3rd\u00e1n" },
            { "type.nu.mymrtlng", "My\u00e1nm\u00e1r Tai Laing M\u00f3rd\u00e1n" },
            { "type.nu.outlined", "Darlikki M\u00f3rd\u00e1n" },
            { "type.nu.romanlow", "L\u00e1tini Kas\u00e1n\u00e9n Nambar" },
            { "type.ca.gregorian", "Mil\u00e1di s\u00e1ldar" },
            { "type.co.gb2312han", "S\u00e1dah kortag\u00e9n Chini Red o band - GB2312" },
            { "type.co.phonebook", "Pawnbokki Red o band" },
            { "type.co.dictionary", "Labzbaladi Red o band" },
            { "type.co.traditional", "Rabyati Red o band" },
            { "type.ca.islamic-rgsa", "Esl\u00e1mi Saudi-Arabi s\u00e1ldar" },
            { "type.ca.islamic-tbla", "Esl\u00e1mi Nojumi s\u00e1ldar" },
            { "type.ca.islamic-civil", "Esl\u00e1mi shahri s\u00e1ldar" },
            { "type.ca.islamic-umalqura", "Esl\u00e1mi Omm al-Korrahi s\u00e1ldar" },
            { "type.ca.ethiopic-amete-alem", "Etupi\u00e1i \u00c1met \u00c1lem s\u00e1ldar" },
        };
        return data;
    }
}
